//
//  InspectorViewGlyphController.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 08.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSInspectorViewController.h>

@class GSLayer;
@class GSInspectorView;
@class GSSteppingTextField;

@interface InspectorViewGlyphController : GSInspectorViewController {
	GSLayer *__weak _previousLayer;
	GSLayer *__weak _nextLayer;

	NSImage *exception;
	NSImage *noException;
	NSImage *rightTransferValue;
	NSImage *leftTransferValue;
}

@property (nonatomic, weak) GSLayer *previousLayer;
@property (nonatomic, weak) GSLayer *nextLayer;
@property (nonatomic, weak) IBOutlet NSButton *leftExceptionButton;
@property (nonatomic, weak) IBOutlet NSButton *rightExceptionButton;
@property (nonatomic, weak) IBOutlet NSTextField *unicodeField;
@property (nonatomic, weak) IBOutlet GSSteppingTextField *leftMetricsField;
@property (nonatomic, weak) IBOutlet NSButton *leftMetricsSyncButton;
@property (nonatomic, weak) IBOutlet GSSteppingTextField *widthField;
@property (nonatomic, weak) IBOutlet NSButton *widthMetricsSyncButton;
@property (nonatomic, weak) IBOutlet GSSteppingTextField *rightMetricsField;
@property (nonatomic, weak) IBOutlet NSButton *rightMetricsSyncButton;
@property (nonatomic, weak) IBOutlet NSTextField *leftKerningField;
@property (nonatomic, weak) IBOutlet NSTextField *leftGroupField;
@property (nonatomic, weak) IBOutlet NSTextField *rightGroupField;
@property (nonatomic, weak) IBOutlet NSTextField *rightKerningField;
@property (nonatomic, weak) IBOutlet NSButton *showInUnicodeCheckerButton;
@property (nonatomic, weak) IBOutlet NSPopUpButton *colorLabelPopup;
@property (nonatomic, weak) IBOutlet GSInspectorView *nameBackgroundView;

@property (nonatomic, weak) IBOutlet NSLayoutConstraint *LSBRightConstraint;
@property (nonatomic, weak) IBOutlet NSLayoutConstraint *RSBLeftConstraint;

#ifndef GLYPHS_VIEWER

- (void)setAlternateButtons:(NSNotification *)theNotification;

- (IBAction)setName:(id)sender;

- (IBAction)setLeftMetricsKey:(id)sender;

- (IBAction)setRightMetricsKey:(id)sender;

- (IBAction)setWidthMetricsKey:(id)sender;

- (IBAction)setLeftKerning:(id)sender;

- (IBAction)setLeftGroup:(id)sender;

- (IBAction)setLeftException:(id)sender;

- (IBAction)setRightKerning:(id)sender;

- (IBAction)setRightGroup:(id)sender;

- (IBAction)setRightException:(id)sender;

- (void)reloadContent;
#endif
@end
